import numpy
import matplotlib.pyplot as pyplot
import scipy.optimize as optimise
from jqc import jqc_plot

pi = numpy.pi

WattsPerVolt = 0.985
atten = 0.91

jqc_plot.plot_style('Large')

data = numpy.genfromtxt("Data.csv",delimiter=',')

f0,errf0 = numpy.average([data[0,1],data[-1,1]],
                    weights=[data[0,2]**-2,data[-1,2]**-2],returned=True)
errf0 = 1/numpy.sqrt(errf0)

print(f0,errf0)

freq = data[1:-1,1]-f0
freq_err = numpy.sqrt(data[1:-1,2]**2+errf0**2)

freq=numpy.insert(freq,0,0)
freq_err=numpy.insert(freq_err,0,errf0)

P = data[:-1,0]*WattsPerVolt*atten
intensity = 1e-7*(P*2)/(pi*172.6e-6**2)

fit_fn = lambda x,A: A*x**2

curve,cov = optimise.curve_fit(fit_fn,intensity,freq,sigma=freq_err,
                                absolute_sigma=True)

fig = pyplot.figure("Shifts")
ax = fig.add_subplot(111)
test_int = numpy.linspace(0,8.5,150)
ax.errorbar(intensity,freq*1e3,yerr=freq_err*1e3,fmt='o',label="$E=100$ V/cm",
            color=jqc_plot.colours['blue'],zorder=1.5)

ax.plot(test_int,fit_fn(test_int,*curve)*1e3,color=jqc_plot.colours['grayblue'],
        zorder=1.2)

ax.set_ylabel("Shift (kHz)")
ax.set_xlabel("Intensity (kW/cm$^2$)")
pyplot.legend()
pyplot.tight_layout()
pyplot.show()
